'use strict';

/* --------------------------------------------------------------
 google_connection_iframe.js 2018-05-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2018 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gx_google_oauth.widgets.module('google_connection_iframe', [], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLE DEFINITION
    // ------------------------------------------------------------------------

    /**
     * Widget Reference
     *
     * @type {object}
     */

    var $this = $(this);

    /**
     * Default Options for Widget
     *
     * @type {object}
     */
    var defaults = {
        connected: false
    };

    /**
     * Final Widget Options
     *
     * @type {object}
     */
    var options = $.extend(true, {}, defaults, data);

    /**
     * Module Object
     *
     * @type {object}
     */
    var module = {};

    /**
     * CSS styles for manually rendered iframe.
     * @type {{width: string, border: string}}
     */
    var iFrameStyles = {
        width: '100%',
        border: 'none',
        'min-height': '190px'
    };

    /**
     * Manually rendered iframe element.
     * Member is available after ::renderIframe function execution.
     */
    var $connectionIFrame = void 0;

    // ------------------------------------------------------------------------
    // FUNCTIONALITY
    // ------------------------------------------------------------------------
    /**
     * Validates widgets and check that all required options exists.
     */
    var validateOptions = function validateOptions() {
        optionExist('url');
        optionExist('origin');
        optionExist('language');
        optionExist('error');
        optionExist('from');
        optionExist('version');
    };

    /**
     * Checks if given option exists and throws error if not.
     *
     * @param {string} option
     */
    var optionExist = function optionExist(option) {
        if (!(option in options)) {
            throw new Error('Required option "' + option + '" is missing');
        }
    };

    // ------------------------------------------------------------------------
    // EVENT HANDLERS
    // ------------------------------------------------------------------------
    /**
     * Renders (manually) the "google connecting iframe".
     * The iframe gets rendered by javascript to improve the post messaging.
     */
    var renderIframe = function renderIframe() {
        var iFrameUrl = options.url + '?origin=' + options.origin + '&from=' + options.from + '&version=' + options.version + '&language=' + options.language + '&error=' + options.error;

        var connected = options.connected === 1;

        if (connected) {
            iFrameUrl = iFrameUrl + '&connected=true';
        }

        $connectionIFrame = $('<iframe/>').attr('src', '../GXModules/Gambio/GoogleOAuth/Admin/Html/initial_iframe_content.html').on('load', requestIframeHeight).css(iFrameStyles);
        $this.parent().empty().append($connectionIFrame);
        $connectionIFrame.attr('src', iFrameUrl);
    };

    /**
     * Requests the iframe height via post message.
     * @param e
     */
    var requestIframeHeight = function requestIframeHeight(e) {
        e.target.contentWindow.postMessage({
            type: 'request_iframe_height'
        }, '*');
    };

    /**
     * Post message response processing for iframe height.
     * @param e
     */
    var responseIframeHeight = function responseIframeHeight(e) {
        if (e.data.type === 'response_iframe_height') {
            $connectionIFrame.css({ 'height': e.data.height.toString() + 'px' });
        }
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    /**
     * Initialize method of the widget, called by the engine.
     */
    module.init = function (done) {
        validateOptions();

        window.addEventListener('message', responseIframeHeight, false);
        renderIframe();

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
